/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.directdot;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.CounterOutputStream;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.dot.Graphviz;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import net.sourceforge.plantuml.cucadiagram.dot.ProcessState;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.UGraphicUtils;

public class PSystemDot
extends AbstractPSystem {
    private final String data;

    public PSystemDot(String data) {
        this.data = data;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("(Dot)", this.getClass());
    }

    @Override
    public ImageData exportDiagram(OutputStream os, int num, FileFormatOption fileFormat) throws IOException {
        Graphviz graphviz = GraphvizUtils.create(this.data, StringUtils.goLowerCase(fileFormat.getFileFormat().name()));
        if (graphviz.illegalDotExe()) {
            GraphicStrings result = GraphicStrings.createDefault(Arrays.asList("There is an issue with your Dot/Graphviz installation"), false);
            UGraphicUtils.writeImage(os, null, fileFormat, new ColorMapperIdentity(), HtmlColorUtils.WHITE, result);
            return new ImageDataSimple();
        }
        CounterOutputStream counter = new CounterOutputStream(os);
        ProcessState state = graphviz.createFile3(counter);
        if (state.differs(ProcessState.TERMINATED_OK())) {
            throw new IllegalStateException("Timeout1 " + state);
        }
        if (counter.getLength() == 0) {
            GraphicStrings result = GraphicStrings.createDefault(Arrays.asList("Graphivz has crashed"), false);
            UGraphicUtils.writeImage(os, null, fileFormat, new ColorMapperIdentity(), HtmlColorUtils.WHITE, result);
        }
        return new ImageDataSimple();
    }
}

